#include "GetPoint.js"

function DoCircleDiameter()
{
	var circlefactory = moi.command.createFactory( 'circlediameter' );

	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();
	
	ui.bindUIToInput( 'vertical', 'value', circlefactory.getInput(2) );

	if ( !GetPoint( pointpicker ) )
		return;

	ui.beginUIUpdate();
	ui.hideUI( 'FirstPrompt' );
	ui.showUI( 'SecondPrompt' );
	ui.endUIUpdate();

	circlefactory.setInput( 0, pointpicker.ptframe );

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, true );
	pointpicker.disableVerticalStraightSnap = true;

	pointpicker.bindResultPt( circlefactory.getInput(1) );
	pointpicker.bindResultOrientation( circlefactory.getInput(0) );

	if ( !GetPoint( pointpicker ) )
		return;
		
	circlefactory.commit();
}	

DoCircleDiameter();
